/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.xml.Xml;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xmlunit.XMLUnitException;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonControllers;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;
import org.xmlunit.diff.NodeMatcher;
import org.xmlunit.placeholder.PlaceholderDifferenceEvaluator;

public class EqualToXmlPattern
extends StringValuePattern {
    private static final Set<ComparisonType> COUNTED_COMPARISONS = Set.of(ComparisonType.ELEMENT_TAG_NAME, ComparisonType.SCHEMA_LOCATION, ComparisonType.NO_NAMESPACE_SCHEMA_LOCATION, ComparisonType.NODE_TYPE, ComparisonType.NAMESPACE_URI, ComparisonType.TEXT_VALUE, ComparisonType.PROCESSING_INSTRUCTION_TARGET, ComparisonType.PROCESSING_INSTRUCTION_DATA, ComparisonType.ELEMENT_NUM_ATTRIBUTES, ComparisonType.ATTR_VALUE, ComparisonType.CHILD_NODELIST_LENGTH, ComparisonType.CHILD_LOOKUP, ComparisonType.ATTR_NAME_LOOKUP);
    private final Boolean enablePlaceholders;
    private final String placeholderOpeningDelimiterRegex;
    private final String placeholderClosingDelimiterRegex;
    private final DifferenceEvaluator diffEvaluator;
    private final Set<ComparisonType> exemptedComparisons;
    private final Document expectedXmlDoc;

    public EqualToXmlPattern(@JsonProperty(value="equalToXml") String expectedValue) {
        this(expectedValue, null, null, null, null);
    }

    public EqualToXmlPattern(@JsonProperty(value="equalToXml") String expectedValue, @JsonProperty(value="enablePlaceholders") Boolean enablePlaceholders, @JsonProperty(value="placeholderOpeningDelimiterRegex") String placeholderOpeningDelimiterRegex, @JsonProperty(value="placeholderClosingDelimiterRegex") String placeholderClosingDelimiterRegex, @JsonProperty(value="exemptedComparisons") Set<ComparisonType> exemptedComparisons) {
        super(expectedValue);
        this.expectedXmlDoc = Xml.read(expectedValue);
        this.enablePlaceholders = enablePlaceholders;
        this.placeholderOpeningDelimiterRegex = placeholderOpeningDelimiterRegex;
        this.placeholderClosingDelimiterRegex = placeholderClosingDelimiterRegex;
        this.exemptedComparisons = exemptedComparisons;
        IgnoreUncountedDifferenceEvaluator baseDifferenceEvaluator = new IgnoreUncountedDifferenceEvaluator(exemptedComparisons);
        this.diffEvaluator = enablePlaceholders != null && enablePlaceholders != false ? DifferenceEvaluators.chain((DifferenceEvaluator[])new DifferenceEvaluator[]{baseDifferenceEvaluator, new PlaceholderDifferenceEvaluator(placeholderOpeningDelimiterRegex, placeholderClosingDelimiterRegex)}) : baseDifferenceEvaluator;
    }

    public String getEqualToXml() {
        return (String)this.expectedValue;
    }

    @Override
    public String getExpected() {
        return Xml.prettyPrint((String)this.getValue());
    }

    public Boolean isEnablePlaceholders() {
        return this.enablePlaceholders;
    }

    public String getPlaceholderOpeningDelimiterRegex() {
        return this.placeholderOpeningDelimiterRegex;
    }

    public String getPlaceholderClosingDelimiterRegex() {
        return this.placeholderClosingDelimiterRegex;
    }

    public Set<ComparisonType> getExemptedComparisons() {
        return this.exemptedComparisons;
    }

    @Override
    public MatchResult match(final String value) {
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                if (Strings.isNullOrEmpty(value)) {
                    return false;
                }
                try {
                    Diff diff = DiffBuilder.compare((Object)Input.from((Object)EqualToXmlPattern.this.expectedXmlDoc)).withTest((Object)value).withComparisonController(ComparisonControllers.StopWhenDifferent).ignoreWhitespace().ignoreComments().withDifferenceEvaluator(EqualToXmlPattern.this.diffEvaluator).withNodeMatcher((NodeMatcher)new OrderInvariantNodeMatcher()).withDocumentBuilderFactory(Xml.newDocumentBuilderFactory()).build();
                    return !diff.hasDifferences();
                }
                catch (XMLUnitException e) {
                    this.appendSubEvent(SubEvent.warning(e.getMessage()));
                    LocalNotifier.notifier().info("Failed to process XML. " + e.getMessage() + "\nExpected:\n" + (String)EqualToXmlPattern.this.expectedValue + "\n\nActual:\n" + value);
                    return false;
                }
            }

            @Override
            public double getDistance() {
                Diff diff;
                if (Strings.isNullOrEmpty(value)) {
                    return 1.0;
                }
                AtomicInteger totalComparisons = new AtomicInteger(0);
                AtomicInteger differences = new AtomicInteger(0);
                try {
                    diff = DiffBuilder.compare((Object)Input.from((Object)EqualToXmlPattern.this.expectedValue)).withTest((Object)value).ignoreWhitespace().ignoreComments().withDifferenceEvaluator(EqualToXmlPattern.this.diffEvaluator).withComparisonListeners(new ComparisonListener[]{(comparison, outcome) -> {
                        if (COUNTED_COMPARISONS.contains(comparison.getType()) && comparison.getControlDetails().getValue() != null) {
                            totalComparisons.incrementAndGet();
                            if (outcome == ComparisonResult.DIFFERENT) {
                                differences.incrementAndGet();
                            }
                        }
                    }}).withDocumentBuilderFactory(Xml.newDocumentBuilderFactory()).build();
                }
                catch (XMLUnitException e) {
                    LocalNotifier.notifier().info("Failed to process XML. " + e.getMessage() + "\nExpected:\n" + (String)EqualToXmlPattern.this.expectedValue + "\n\nActual:\n" + value);
                    return 1.0;
                }
                LocalNotifier.notifier().info(StreamSupport.stream(diff.getDifferences().spliterator(), false).map(Object::toString).collect(Collectors.joining("\n")));
                return differences.doubleValue() / totalComparisons.doubleValue();
            }
        };
    }

    public EqualToXmlPattern exemptingComparisons(ComparisonType ... comparisons) {
        return new EqualToXmlPattern((String)this.expectedValue, this.enablePlaceholders, this.placeholderOpeningDelimiterRegex, this.placeholderClosingDelimiterRegex, new HashSet<ComparisonType>(Arrays.asList(comparisons)));
    }

    private static final class OrderInvariantNodeMatcher
    extends DefaultNodeMatcher {
        private static final Comparator<Node> COMPARATOR = Comparator.comparing(Node::getLocalName);

        private OrderInvariantNodeMatcher() {
        }

        public Iterable<Map.Entry<Node, Node>> match(Iterable<Node> controlNodes, Iterable<Node> testNodes) {
            return super.match(OrderInvariantNodeMatcher.sort(controlNodes), OrderInvariantNodeMatcher.sort(testNodes));
        }

        private static Iterable<Node> sort(Iterable<Node> nodes) {
            return StreamSupport.stream(nodes.spliterator(), false).sorted(COMPARATOR).collect(Collectors.toList());
        }
    }

    private static class IgnoreUncountedDifferenceEvaluator
    implements DifferenceEvaluator {
        private final Set<ComparisonType> finalCountedComparisons;

        public IgnoreUncountedDifferenceEvaluator(Set<ComparisonType> exemptedComparisons) {
            this.finalCountedComparisons = exemptedComparisons != null ? COUNTED_COMPARISONS.stream().filter(e -> !exemptedComparisons.contains(e)).collect(Collectors.toSet()) : COUNTED_COMPARISONS;
        }

        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            if (this.finalCountedComparisons.contains(comparison.getType()) && comparison.getControlDetails().getValue() != null) {
                return outcome;
            }
            return ComparisonResult.EQUAL;
        }
    }
}

