/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification.diff;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.common.url.PathTemplate;
import com.github.tomakehurst.wiremock.common.xml.Xml;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.FormParameter;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipleMatchMultiValuePattern;
import com.github.tomakehurst.wiremock.matching.PathPattern;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.SingleMatchMultiValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPathPattern;
import com.github.tomakehurst.wiremock.matching.UrlPathTemplatePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.diff.DiffLine;
import com.github.tomakehurst.wiremock.verification.diff.InlineCustomMatcherLine;
import com.github.tomakehurst.wiremock.verification.diff.JUnitStyleDiffRenderer;
import com.github.tomakehurst.wiremock.verification.diff.NamedCustomMatcherLine;
import com.github.tomakehurst.wiremock.verification.diff.SectionDelimiter;
import com.github.tomakehurst.wiremock.verification.diff.SpacerLine;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Diff {
    private final String stubMappingName;
    private final RequestPattern requestPattern;
    private final Request request;
    private final String scenarioName;
    private final String scenarioState;
    private final String expectedScenarioState;

    public Diff(RequestPattern expected, Request actual) {
        this.requestPattern = expected;
        this.request = actual;
        this.stubMappingName = null;
        this.scenarioName = null;
        this.scenarioState = null;
        this.expectedScenarioState = null;
    }

    public Diff(StubMapping expected, Request actual) {
        this(expected, actual, null);
    }

    public Diff(StubMapping expected, Request actual, String scenarioState) {
        this.requestPattern = expected.getRequest();
        this.request = actual;
        this.stubMappingName = expected.getName();
        this.scenarioName = expected.getScenarioName();
        this.scenarioState = scenarioState;
        this.expectedScenarioState = expected.getRequiredScenarioState();
    }

    public String toString() {
        return new JUnitStyleDiffRenderer().render(this);
    }

    public List<DiffLine<?>> getLines() {
        return this.getLines(Collections.emptyMap());
    }

    public List<DiffLine<?>> getLines(Map<String, RequestMatcherExtension> customMatcherExtensions) {
        LinkedList diffLineList = new LinkedList();
        this.addHostSectionIfPresent(diffLineList);
        this.addPortSectionIfPresent(diffLineList);
        this.addSchemeSectionIfPresent(diffLineList);
        this.addMethodSection(diffLineList);
        UrlPattern urlPattern = ParameterUtils.getFirstNonNull(this.requestPattern.getUrlMatcher(), WireMock.anyUrl());
        DiffLine<String> urlSection = this.addUrlSectionWithSpacer(urlPattern, diffLineList);
        this.addHeaderSectionWithSpacerIfPresent(this.requestPattern.combineBasicAuthAndOtherHeaders(), this.request.getHeaders(), diffLineList);
        this.addPathParameterSectionWithSpacerIfPresent(urlPattern, urlSection, diffLineList);
        this.addQueryParametersSectionWithSpacerIfPresent(diffLineList);
        this.addFormParametersSectionWithSpacerIfPresent(diffLineList);
        this.addCookiesSectionWithSpacerIfPresent(diffLineList);
        this.addBodySectionIfPresent(diffLineList);
        this.addMultipartSectionWithSpacerIfPresent(diffLineList);
        this.addInlineCustomMatcherSectionIfPresent(diffLineList);
        this.addNamedCustomMatcherSectionIfPresent(customMatcherExtensions, diffLineList);
        this.addScenarioSectionIfPresent(diffLineList);
        return diffLineList;
    }

    private void addScenarioSectionIfPresent(List<DiffLine<?>> diffLineList) {
        if (this.scenarioName != null && this.expectedScenarioState != null) {
            diffLineList.add(new DiffLine<String>("Scenario", new EqualToPattern(this.expectedScenarioState), Diff.buildScenarioLine(this.scenarioName, this.scenarioState), Diff.buildScenarioLine(this.scenarioName, this.expectedScenarioState)));
        }
    }

    private void addNamedCustomMatcherSectionIfPresent(Map<String, RequestMatcherExtension> customMatcherExtensions, List<DiffLine<?>> diffLineList) {
        if (this.requestPattern.hasNamedCustomMatcher()) {
            RequestMatcherExtension customMatcher = customMatcherExtensions.get(this.requestPattern.getCustomMatcher().getName());
            if (customMatcher != null) {
                NamedCustomMatcherLine namedCustomMatcherLine = new NamedCustomMatcherLine(customMatcher, this.requestPattern.getCustomMatcher().getParameters(), this.request);
                diffLineList.add(namedCustomMatcherLine);
            } else {
                diffLineList.add(new SectionDelimiter("[custom matcher: " + this.requestPattern.getCustomMatcher().getName() + "]"));
            }
        }
    }

    private void addInlineCustomMatcherSectionIfPresent(List<DiffLine<?>> diffLineList) {
        if (this.requestPattern.hasInlineCustomMatcher()) {
            InlineCustomMatcherLine customMatcherLine = new InlineCustomMatcherLine(this.requestPattern.getMatcher(), this.request);
            diffLineList.add(customMatcherLine);
        }
    }

    private void addMultipartSectionWithSpacerIfPresent(List<DiffLine<?>> diffLineList) {
        List<MultipartValuePattern> multipartPatterns = this.requestPattern.getMultipartPatterns();
        if (multipartPatterns != null && !multipartPatterns.isEmpty()) {
            for (MultipartValuePattern pattern : multipartPatterns) {
                if (!this.request.isMultipart()) {
                    diffLineList.add(new SectionDelimiter("[Multipart request body]", ""));
                    continue;
                }
                if (pattern.match(this.request).isExactMatch()) continue;
                for (Request.Part part : this.request.getParts()) {
                    diffLineList.add(SpacerLine.SPACER);
                    String patternPartName = pattern.getName() == null ? "" : ": " + pattern.getName();
                    String partName = part.getName() == null ? "" : part.getName();
                    diffLineList.add(new SectionDelimiter("[Multipart" + patternPartName + "]", "[" + partName + "]"));
                    diffLineList.add(SpacerLine.SPACER);
                    if (!pattern.match(part).isExactMatch()) {
                        this.addHeaderSectionWithSpacerIfPresent(pattern.getHeaders(), part.getHeaders(), diffLineList);
                        this.addBodySectionIfPresent(pattern.getBodyPatterns(), part.getBody(), diffLineList);
                        diffLineList.add(SpacerLine.SPACER);
                    }
                    diffLineList.add(new SectionDelimiter("[/Multipart]", "[/" + partName + "]"));
                    diffLineList.add(SpacerLine.SPACER);
                }
            }
        }
    }

    private void addCookiesSectionWithSpacerIfPresent(List<DiffLine<?>> diffLineList) {
        Map<String, StringValuePattern> cookiesPattern = this.requestPattern.getCookies();
        if (cookiesPattern != null) {
            Map cookies = ParameterUtils.getFirstNonNull(this.request.getCookies(), Collections.emptyMap());
            for (Map.Entry<String, StringValuePattern> entry : cookiesPattern.entrySet()) {
                String key = entry.getKey();
                StringValuePattern pattern = entry.getValue();
                Cookie cookie = ParameterUtils.getFirstNonNull((Cookie)cookies.get(key), Cookie.absent());
                String operator = this.generateOperatorString(pattern, "=");
                DiffLine<String> section = new DiffLine<String>("Cookie", pattern, cookie.isPresent() ? cookie.getValue() : "", "Cookie: " + key + operator + (String)pattern.getValue());
                diffLineList.add(section);
            }
            if (!cookiesPattern.isEmpty()) {
                diffLineList.add(SpacerLine.SPACER);
            }
        }
    }

    private void addFormParametersSectionWithSpacerIfPresent(List<DiffLine<?>> diffLineList) {
        Map<String, MultiValuePattern> formParameters = this.requestPattern.getFormParameters();
        if (formParameters != null) {
            Map<String, FormParameter> requestFormParameters = this.request.formParameters();
            for (Map.Entry<String, MultiValuePattern> entry : formParameters.entrySet()) {
                String key = entry.getKey();
                MultiValuePattern pattern = entry.getValue();
                FormParameter formParameter = ParameterUtils.getFirstNonNull(requestFormParameters.get(key), FormParameter.absent(key));
                String operator = this.generateOperatorStringForMultiValuePattern(pattern, " = ");
                DiffLine<FormParameter> section = new DiffLine<FormParameter>("Form data", pattern, formParameter, "Form: " + key + operator + pattern.getExpected());
                diffLineList.add(section);
            }
            if (!formParameters.isEmpty()) {
                diffLineList.add(SpacerLine.SPACER);
            }
        }
    }

    private void addQueryParametersSectionWithSpacerIfPresent(List<DiffLine<?>> diffLineList) {
        Map<String, MultiValuePattern> queryParameters = this.requestPattern.getQueryParameters();
        if (queryParameters != null) {
            Map<String, QueryParameter> requestQueryParams = Urls.splitQuery(URI.create(this.request.getUrl()));
            for (Map.Entry<String, MultiValuePattern> entry : queryParameters.entrySet()) {
                String key = entry.getKey();
                MultiValuePattern pattern = entry.getValue();
                QueryParameter queryParameter = ParameterUtils.getFirstNonNull(requestQueryParams.get(key), QueryParameter.absent(key));
                String operator = this.generateOperatorStringForMultiValuePattern(pattern, " = ");
                DiffLine<QueryParameter> section = new DiffLine<QueryParameter>("Query", pattern, queryParameter, "Query: " + key + operator + pattern.getExpected());
                diffLineList.add(section);
            }
            if (!queryParameters.isEmpty()) {
                diffLineList.add(SpacerLine.SPACER);
            }
        }
    }

    private void addPathParameterSectionWithSpacerIfPresent(UrlPattern urlPattern, DiffLine<String> urlSection, List<DiffLine<?>> diffLineList) {
        Map<String, StringValuePattern> pathParameters = this.requestPattern.getPathParameters();
        if (urlPattern instanceof UrlPathTemplatePattern && pathParameters != null && !pathParameters.isEmpty() && urlSection.isExactMatch()) {
            UrlPathTemplatePattern urlPathTemplatePattern = (UrlPathTemplatePattern)this.requestPattern.getUrlMatcher();
            PathTemplate pathTemplate = urlPathTemplatePattern.getPathTemplate();
            PathParams requestPathParameterValues = pathTemplate.parse(Urls.getPath(this.request.getUrl()));
            for (Map.Entry entry : requestPathParameterValues.entrySet()) {
                String parameterName = (String)entry.getKey();
                String parameterValue = parameterName + ": " + (String)entry.getValue();
                StringValuePattern pattern = pathParameters.get(parameterName);
                String operator = this.generateOperatorString(pattern, " = ");
                DiffLine<CallSite> section = new DiffLine<CallSite>("Path parameter", pattern, (CallSite)((Object)parameterValue), "Path parameter: " + parameterName + operator + (String)pattern.getValue());
                diffLineList.add(section);
            }
            diffLineList.add(SpacerLine.SPACER);
        }
    }

    private DiffLine<String> addUrlSectionWithSpacer(UrlPattern urlPattern, List<DiffLine<?>> diffLineList) {
        String printedUrlPattern = this.generatePrintedUrlPattern(urlPattern);
        DiffLine<String> urlSection = new DiffLine<String>("URL", urlPattern, this.request.getUrl(), printedUrlPattern);
        diffLineList.add(urlSection);
        diffLineList.add(SpacerLine.SPACER);
        return urlSection;
    }

    private void addMethodSection(List<DiffLine<?>> diffLineList) {
        DiffLine<RequestMethod> methodSection = new DiffLine<RequestMethod>("HTTP method", this.requestPattern.getMethod(), this.request.getMethod(), this.requestPattern.getMethod().getName());
        diffLineList.add(methodSection);
    }

    private void addSchemeSectionIfPresent(List<DiffLine<?>> diffLineList) {
        if (this.requestPattern.getScheme() != null) {
            StringValuePattern expectedScheme = WireMock.equalTo(String.valueOf(this.requestPattern.getScheme()));
            DiffLine<String> schemeSection = new DiffLine<String>("Scheme", expectedScheme, this.request.getScheme(), this.requestPattern.getScheme());
            diffLineList.add(schemeSection);
        }
    }

    private void addPortSectionIfPresent(List<DiffLine<?>> diffLineList) {
        if (this.requestPattern.getPort() != null) {
            StringValuePattern expectedPort = WireMock.equalTo(String.valueOf(this.requestPattern.getPort()));
            String actualPort = String.valueOf(this.request.getPort());
            DiffLine<String> portSection = new DiffLine<String>("Port", expectedPort, actualPort, expectedPort.getExpected());
            diffLineList.add(portSection);
        }
    }

    private void addHostSectionIfPresent(List<DiffLine<?>> diffLineList) {
        if (this.requestPattern.getHost() != null) {
            String hostOperator = this.generateOperatorString(this.requestPattern.getHost(), "");
            String printedHostPatternValue = hostOperator + this.requestPattern.getHost().getExpected();
            DiffLine<String> hostSection = new DiffLine<String>("Host", this.requestPattern.getHost(), this.request.getHost(), printedHostPatternValue.trim());
            diffLineList.add(hostSection);
        }
    }

    private static String buildScenarioLine(String scenarioName, String scenarioState) {
        return "[Scenario '" + scenarioName + "' state: " + scenarioState + "]";
    }

    private void addHeaderSectionWithSpacerIfPresent(Map<String, MultiValuePattern> headerPatterns, HttpHeaders headers, List<DiffLine<?>> builder) {
        if (headerPatterns != null && !headerPatterns.isEmpty()) {
            for (String key : headerPatterns.keySet()) {
                HttpHeader header = headers.getHeader(key);
                MultiValuePattern headerPattern = headerPatterns.get(header.key());
                String operator = this.generateOperatorStringForMultiValuePattern(headerPattern, "");
                String expected = StringUtils.isEmpty((CharSequence)headerPattern.getExpected()) ? "" : ": " + headerPattern.getExpected();
                String printedPatternValue = header.key() + operator + expected;
                DiffLine<HttpHeader> section = new DiffLine<HttpHeader>("Header", headerPattern, header, printedPatternValue);
                builder.add(section);
            }
            builder.add(SpacerLine.SPACER);
        }
    }

    private void addBodySectionIfPresent(List<ContentPattern<?>> bodyPatterns, Body body, List<DiffLine<?>> builder) {
        if (bodyPatterns != null && !bodyPatterns.isEmpty()) {
            for (ContentPattern<?> pattern : bodyPatterns) {
                String formattedBody = Diff.formatIfJsonOrXml(pattern, body);
                if (PathPattern.class.isAssignableFrom(pattern.getClass())) {
                    PathPattern pathPattern = (PathPattern)pattern;
                    if (!pathPattern.isSimple()) {
                        String expressionResultString = Diff.getExpressionResultString(body, pathPattern);
                        String printedExpectedValue = pathPattern.getExpected() + " [" + pathPattern.getValuePattern().getName() + "] " + pathPattern.getValuePattern().getExpected();
                        if (expressionResultString != null) {
                            builder.add(new DiffLine<String>("Body", pathPattern.getValuePattern(), expressionResultString, printedExpectedValue));
                            continue;
                        }
                        builder.add(new DiffLine<String>("Body", pathPattern, formattedBody, printedExpectedValue));
                        continue;
                    }
                    builder.add(new DiffLine<String>("Body", pathPattern, formattedBody, pattern.getExpected()));
                    continue;
                }
                if (StringValuePattern.class.isAssignableFrom(pattern.getClass())) {
                    StringValuePattern stringValuePattern = (StringValuePattern)pattern;
                    String printedPatternValue = "[" + pattern.getName() + "]\n" + pattern.getExpected();
                    builder.add(new DiffLine<CallSite>("Body", stringValuePattern, (CallSite)((Object)("\n" + formattedBody)), printedPatternValue));
                    continue;
                }
                BinaryEqualToPattern nonStringPattern = (BinaryEqualToPattern)pattern;
                builder.add(new DiffLine<byte[]>("Body", nonStringPattern, formattedBody.getBytes(), pattern.getExpected()));
            }
        }
    }

    private void addBodySectionIfPresent(List<DiffLine<?>> builder) {
        List<ContentPattern<?>> bodyPatterns = this.requestPattern.getBodyPatterns();
        Body body = new Body(this.request.getBody());
        this.addBodySectionIfPresent(bodyPatterns, body, builder);
    }

    private static String getExpressionResultString(Body body, PathPattern pathPattern) {
        String bodyStr = body.asString();
        if (StringUtils.isEmpty((CharSequence)bodyStr)) {
            return null;
        }
        try {
            ListOrSingle<String> expressionResult = pathPattern.getExpressionResult(bodyStr);
            return expressionResult != null && !expressionResult.isEmpty() ? expressionResult.toString() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String generatePrintedUrlPattern(UrlPattern urlPattern) {
        Object matchPart = urlPattern instanceof UrlPathTemplatePattern ? "path template" : (urlPattern instanceof UrlPathPattern ? "path" : "") + (urlPattern.isRegex() ? " regex" : "");
        matchPart = ((String)matchPart).trim();
        return ((String)matchPart).isEmpty() ? urlPattern.getExpected() : "[" + (String)matchPart + "] " + urlPattern.getExpected();
    }

    private String generateOperatorString(ContentPattern<?> pattern, String defaultValue) {
        return Diff.isAnEqualToPattern(pattern) ? defaultValue : " [" + pattern.getName() + "] ";
    }

    private String generateOperatorStringForMultiValuePattern(MultiValuePattern valuePattern, String defaultValue) {
        if (valuePattern instanceof MultipleMatchMultiValuePattern) {
            return ((MultipleMatchMultiValuePattern)valuePattern).getOperator() + "[" + valuePattern.getName() + "]";
        }
        return Diff.isAnEqualToPattern(((SingleMatchMultiValuePattern)valuePattern).getValuePattern()) ? defaultValue : " [" + valuePattern.getName() + "] ";
    }

    public String getStubMappingName() {
        return this.stubMappingName;
    }

    private static String formatIfJsonOrXml(ContentPattern<?> pattern, Body body) {
        if (body == null || body.isAbsent()) {
            return "";
        }
        try {
            return pattern.getClass().equals(EqualToJsonPattern.class) ? Json.prettyPrint(Json.write(body.asJson())) : (pattern.getClass().equals(EqualToXmlPattern.class) ? Xml.prettyPrint(body.asString()) : (pattern.getClass().equals(BinaryEqualToPattern.class) ? body.asBase64() : body.asString()));
        }
        catch (Exception e) {
            return body.asString();
        }
    }

    private static boolean isAnEqualToPattern(ContentPattern<?> pattern) {
        return pattern instanceof EqualToPattern || pattern instanceof EqualToJsonPattern || pattern instanceof EqualToXmlPattern || pattern instanceof BinaryEqualToPattern;
    }
}

