/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.io.IOException;
import java.util.UUID;

public class HandlebarsRandomValuesHelper
extends HandlebarsHelper<Void> {
    public Object apply(Void context, Options options) throws IOException {
        String rawValue;
        String type;
        int length = (Integer)options.hash("length", (Object)36);
        boolean uppercase = (Boolean)options.hash("uppercase", (Object)false);
        switch (type = (String)options.hash("type", (Object)"ALPHANUMERIC")) {
            case "ALPHANUMERIC": {
                rawValue = Strings.randomAlphanumeric(length);
                break;
            }
            case "ALPHABETIC": {
                rawValue = Strings.randomAlphabetic(length);
                break;
            }
            case "NUMERIC": {
                rawValue = Strings.randomNumeric(length);
                break;
            }
            case "ALPHANUMERIC_AND_SYMBOLS": {
                rawValue = Strings.random(length, 33, 126, false, false);
                break;
            }
            case "UUID": {
                rawValue = UUID.randomUUID().toString();
                break;
            }
            case "HEXADECIMAL": {
                rawValue = Strings.random(length, "ABCDEF0123456789");
                break;
            }
            default: {
                rawValue = Strings.randomAscii(length);
            }
        }
        return uppercase ? rawValue.toUpperCase() : rawValue.toLowerCase();
    }
}

