/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.common.url.PathTemplate;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.FormParameter;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public class RequestPathParamsDecorator
implements Request {
    private final Request request;
    private final PathTemplate pathTemplate;

    public static Request decorate(Request request, RequestPattern requestPattern) {
        PathTemplate pathTemplate = requestPattern.getUrlMatcher().getPathTemplate();
        return pathTemplate != null ? new RequestPathParamsDecorator(request, pathTemplate) : request;
    }

    public RequestPathParamsDecorator(Request request, PathTemplate pathTemplate) {
        this.request = request;
        this.pathTemplate = pathTemplate;
    }

    @Override
    public UUID getId() {
        return this.request.getId();
    }

    @Override
    public String getUrl() {
        return this.request.getUrl();
    }

    @Override
    public String getAbsoluteUrl() {
        return this.request.getAbsoluteUrl();
    }

    @Override
    public RequestMethod getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getScheme() {
        return this.request.getScheme();
    }

    @Override
    public String getHost() {
        return this.request.getHost();
    }

    @Override
    public int getPort() {
        return this.request.getPort();
    }

    @Override
    public String getClientIp() {
        return this.request.getClientIp();
    }

    @Override
    public String getHeader(String key) {
        return this.request.getHeader(key);
    }

    @Override
    public HttpHeader header(String key) {
        return this.request.header(key);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        return this.request.contentTypeHeader();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.request.getHeaders();
    }

    @Override
    public boolean containsHeader(String key) {
        return this.request.containsHeader(key);
    }

    @Override
    public Set<String> getAllHeaderKeys() {
        return this.request.getAllHeaderKeys();
    }

    @Override
    public PathParams getPathParameters() {
        return this.pathTemplate.parse(this.getUrl());
    }

    @Override
    public QueryParameter queryParameter(String key) {
        return this.request.queryParameter(key);
    }

    @Override
    public FormParameter formParameter(String key) {
        return this.request.formParameter(key);
    }

    @Override
    public Map<String, FormParameter> formParameters() {
        return this.request.formParameters();
    }

    @Override
    public Map<String, Cookie> getCookies() {
        return this.request.getCookies();
    }

    @Override
    public byte[] getBody() {
        return this.request.getBody();
    }

    @Override
    public String getBodyAsString() {
        return this.request.getBodyAsString();
    }

    @Override
    public String getBodyAsBase64() {
        return this.request.getBodyAsBase64();
    }

    @Override
    public boolean isMultipart() {
        return this.request.isMultipart();
    }

    @Override
    public Collection<Request.Part> getParts() {
        return this.request.getParts();
    }

    @Override
    public Request.Part getPart(String name) {
        return this.request.getPart(name);
    }

    @Override
    public boolean isBrowserProxyRequest() {
        return this.request.isBrowserProxyRequest();
    }

    @Override
    public Optional<Request> getOriginalRequest() {
        return this.request.getOriginalRequest();
    }

    @Override
    public String getProtocol() {
        return this.request.getProtocol();
    }
}

