/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty;

import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.eclipse.jetty.util.Jetty;

public interface JettyHttpServerFactoryLoader {
    public Optional<HttpServerFactory> getHttpServerFactory(String var1);

    public static HttpServerFactory create(String jettyVersion) {
        String[] version = Jetty.VERSION.split("[.]");
        if (version.length == 0 || version[0].isBlank()) {
            throw new IllegalArgumentException("Unrecognized Jetty version: " + jettyVersion + ". Please make sure the right Jetty dependencies are on the classpath.");
        }
        String jettyMajorVersion = version[0];
        ServiceLoader<JettyHttpServerFactoryLoader> loaders = ServiceLoader.load(JettyHttpServerFactoryLoader.class);
        ServiceConfigurationError cause = null;
        try {
            for (JettyHttpServerFactoryLoader loader : loaders) {
                Optional<HttpServerFactory> factoryOpt = loader.getHttpServerFactory(jettyMajorVersion);
                if (!factoryOpt.isPresent()) continue;
                return factoryOpt.get();
            }
        }
        catch (ServiceConfigurationError ex) {
            cause = ex;
        }
        throw new IllegalStateException("Unable to find JettyHttpServerFactoryLoader for Jetty version " + jettyMajorVersion + " (only Jetty 11/12 are supported at the moment). Please make sure the right Jetty dependencies are on the classpath.", cause);
    }
}

