/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.Socket;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Response;

public interface JettyHttpUtils {
    public static final boolean IS_JETTY = JettyHttpUtils.isClassExist("org.eclipse.jetty.server.Request");

    public static boolean isJetty() {
        return IS_JETTY;
    }

    private static boolean isClassExist(String type) {
        try {
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            ClassLoader loader = contextCL == null ? JettyHttpUtils.class.getClassLoader() : contextCL;
            Class.forName(type, false, loader);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Response unwrapResponse(HttpServletResponse var1);

    public Socket socket(Response var1);

    public void setStatusWithReason(int var1, String var2, HttpServletResponse var3);

    public Socket tlsSocket(Response var1);

    public EndPoint unwrapEndPoint(Response var1);

    public boolean isBrowserProxyRequest(HttpServletRequest var1);
}

