/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty11;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.jetty.JettyHttpUtils;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SelectableChannelEndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public class Jetty11HttpUtils
implements JettyHttpUtils {
    @Override
    public Response unwrapResponse(HttpServletResponse httpServletResponse) {
        if (httpServletResponse instanceof HttpServletResponseWrapper) {
            ServletResponse unwrapped = ((HttpServletResponseWrapper)httpServletResponse).getResponse();
            return (Response)unwrapped;
        }
        return (Response)httpServletResponse;
    }

    @Override
    public Socket socket(Response response) {
        HttpChannel httpChannel = response.getHttpOutput().getHttpChannel();
        SelectableChannelEndPoint ep = (SelectableChannelEndPoint)httpChannel.getEndPoint();
        return ((SocketChannel)ep.getChannel()).socket();
    }

    @Override
    public Socket tlsSocket(Response response) {
        HttpChannel httpChannel = response.getHttpOutput().getHttpChannel();
        SslConnection.DecryptedEndPoint sslEndpoint = (SslConnection.DecryptedEndPoint)httpChannel.getEndPoint();
        EndPoint endpoint = sslEndpoint.getSslConnection().getEndPoint();
        try {
            SocketChannel channel = (SocketChannel)endpoint.getClass().getMethod("getChannel", new Class[0]).invoke((Object)endpoint, new Object[0]);
            return channel.socket();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, Socket.class);
        }
    }

    @Override
    public void setStatusWithReason(int status, String reason, HttpServletResponse httpServletResponse) {
        if (httpServletResponse instanceof Response) {
            Response jettyResponse = (Response)httpServletResponse;
            jettyResponse.setStatusWithReason(status, reason);
        } else {
            httpServletResponse.setStatus(status, reason);
        }
    }

    @Override
    public EndPoint unwrapEndPoint(Response jettyResponse) {
        return jettyResponse.getHttpOutput().getHttpChannel().getEndPoint();
    }

    @Override
    public boolean isBrowserProxyRequest(HttpServletRequest request) {
        if (request instanceof Request) {
            Request jettyRequest = (Request)request;
            return Boolean.TRUE.equals(request.getAttribute("wiremock.isHttpsProxyRequest")) || "http".equals(jettyRequest.getMetaData().getURI().getScheme());
        }
        return false;
    }
}

