/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.ssl;

import com.github.tomakehurst.wiremock.http.ssl.TrustStrategy;
import java.net.InetAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLEngine;

public class TrustSpecificHostsStrategy
implements TrustStrategy {
    private final List<String> trustedHosts;

    public TrustSpecificHostsStrategy(List<String> trustedHosts) {
        this.trustedHosts = new ArrayList<String>(trustedHosts);
    }

    @Override
    public boolean isTrusted(X509Certificate[] chain, String authType) {
        return false;
    }

    @Override
    public boolean isTrusted(X509Certificate[] chain, String authType, Socket socket) {
        InetAddress inetAddress = socket.getInetAddress();
        return this.trustedHosts.contains(inetAddress.getHostName()) || this.trustedHosts.contains(inetAddress.getHostAddress());
    }

    @Override
    public boolean isTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
        return false;
    }
}

