/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.CollectorContext;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.RequiredValidator;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class NotValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private final JsonSchema schema;

    public NotValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.NOT, validationContext);
        this.schema = validationContext.newSchema(schemaPath, schemaNode, parentSchema);
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        CollectorContext collectorContext = CollectorContext.getInstance();
        Set<Object> errors = new HashSet();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        try {
            NotValidator.debug(logger, node, rootNode, at);
            errors = this.schema.validate(node, rootNode, at);
            if (errors.isEmpty()) {
                Set<ValidationMessage> set = Collections.singleton(this.buildValidationMessage(at, this.schema.toString()));
                return set;
            }
            Set<ValidationMessage> set = Collections.emptySet();
            return set;
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(node, rootNode, at);
        }
        Set<ValidationMessage> errors = this.schema.walk(node, rootNode, at, shouldValidateSchema);
        if (errors.isEmpty()) {
            return Collections.singleton(this.buildValidationMessage(at, this.schema.toString()));
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.schema) {
            this.schema.initializeValidators();
        }
    }
}

