/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.CollectorContext;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorState;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class OneOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(OneOfValidator.class);
    private final List<JsonSchema> schemas = new ArrayList<JsonSchema>();

    public OneOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ONE_OF, validationContext);
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            JsonNode childNode = schemaNode.get(i);
            this.schemas.add(validationContext.newSchema(schemaPath + "/" + i, childNode, parentSchema));
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        CollectorContext collectorContext = CollectorContext.getInstance();
        CollectorContext.Scope grandParentScope = collectorContext.enterDynamicScope();
        try {
            OneOfValidator.debug(logger, node, rootNode, at);
            ValidatorState state = (ValidatorState)collectorContext.get("wiremock.com.networknt.schema.ValidatorState");
            state.setComplexValidator(true);
            int numberOfValidSchema = 0;
            LinkedHashSet<Object> childErrors = new LinkedHashSet<Object>();
            for (JsonSchema schema : this.schemas) {
                Set<Object> schemaErrors = Collections.emptySet();
                CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
                try {
                    state.setMatchedNode(true);
                    schemaErrors = !state.isWalkEnabled() ? schema.validate(node, rootNode, at) : schema.walk(node, rootNode, at, state.isValidationEnabled());
                    if (schemaErrors.isEmpty()) {
                        if (!state.hasMatchedNode()) continue;
                        ++numberOfValidSchema;
                    }
                    if (numberOfValidSchema > 1) break;
                    childErrors.addAll(schemaErrors);
                }
                finally {
                    CollectorContext.Scope scope = collectorContext.exitDynamicScope();
                    if (!schemaErrors.isEmpty()) continue;
                    parentScope.mergeWith(scope);
                }
            }
            if (numberOfValidSchema != 1) {
                ValidationMessage message = this.buildValidationMessage(at, Integer.toString(numberOfValidSchema));
                if (this.failFast) {
                    throw new JsonSchemaException(message);
                }
                errors.add(message);
                errors.addAll(childErrors);
                collectorContext.getEvaluatedItems().clear();
                collectorContext.getEvaluatedProperties().clear();
            }
            if (errors.isEmpty()) {
                state.setMatchedNode(true);
            }
            OneOfValidator.resetValidatorState();
            Set set = Collections.unmodifiableSet(errors);
            return set;
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (errors.isEmpty()) {
                grandParentScope.mergeWith(scope);
            }
        }
    }

    private static void resetValidatorState() {
        ValidatorState state = (ValidatorState)CollectorContext.getInstance().get("wiremock.com.networknt.schema.ValidatorState");
        state.setComplexValidator(false);
        state.setMatchedNode(true);
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (shouldValidateSchema) {
            validationMessages.addAll(this.validate(node, rootNode, at));
        } else {
            for (JsonSchema schema : this.schemas) {
                schema.walk(node, rootNode, at, shouldValidateSchema);
            }
        }
        return validationMessages;
    }

    @Override
    public void preloadJsonSchema() {
        for (JsonSchema schema : this.schemas) {
            schema.initializeValidators();
        }
    }
}

