/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.CollectorContext;
import wiremock.com.networknt.schema.CustomErrorMessageType;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class RecursiveRefValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RecursiveRefValidator.class);

    public RecursiveRefValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.RECURSIVE_REF, validationContext);
        String refValue = schemaNode.asText();
        if (!"#".equals(refValue)) {
            throw new JsonSchemaException(ValidationMessage.of(ValidatorTypeCode.RECURSIVE_REF.getValue(), CustomErrorMessageType.of("internal.invalidRecursiveRef"), new MessageFormat("{0}: The value of a $recursiveRef must be '#' but is '{1}'"), schemaPath, schemaPath, refValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        CollectorContext collectorContext = CollectorContext.getInstance();
        Set<ValidationMessage> errors = new HashSet<ValidationMessage>();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        try {
            RecursiveRefValidator.debug(logger, node, rootNode, at);
            JsonSchema schema = collectorContext.getOutermostSchema();
            if (null != schema) {
                schema.getValidationContext().setConfig(this.getParentSchema().getValidationContext().getConfig());
                errors = schema.validate(node, rootNode, at);
            }
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        CollectorContext collectorContext = CollectorContext.getInstance();
        Set<ValidationMessage> errors = new HashSet<ValidationMessage>();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        try {
            RecursiveRefValidator.debug(logger, node, rootNode, at);
            JsonSchema schema = collectorContext.getOutermostSchema();
            if (null != schema) {
                schema.getValidationContext().setConfig(this.getParentSchema().getValidationContext().getConfig());
                errors = schema.walk(node, rootNode, at, shouldValidateSchema);
            }
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (shouldValidateSchema && errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
        return errors;
    }
}

