/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.sysoutslf4j.system;

import java.io.PrintStream;
import uk.org.lidalia.sysoutslf4j.common.PrintStreamCoordinator;
import uk.org.lidalia.sysoutslf4j.common.SLF4JPrintStream;
import uk.org.lidalia.sysoutslf4j.common.SystemOutput;
import uk.org.lidalia.sysoutslf4j.system.LoggerAppenderStore;
import uk.org.lidalia.sysoutslf4j.system.SLF4JPrintStreamDelegate;
import uk.org.lidalia.sysoutslf4j.system.SLF4JPrintStreamImpl;

public final class PrintStreamCoordinatorImpl
implements PrintStreamCoordinator {
    @Override
    public void replaceSystemOutputsWithSLF4JPrintStreams() {
        for (SystemOutput systemOutput : SystemOutput.values()) {
            PrintStreamCoordinatorImpl.replaceSystemOutputWithSLF4JPrintStream(systemOutput);
        }
    }

    private static void replaceSystemOutputWithSLF4JPrintStream(SystemOutput systemOutput) {
        SLF4JPrintStreamImpl slf4jPrintStream = PrintStreamCoordinatorImpl.buildSLF4JPrintStream(systemOutput.get());
        systemOutput.set(slf4jPrintStream);
    }

    private static SLF4JPrintStreamImpl buildSLF4JPrintStream(PrintStream originalPrintStream) {
        LoggerAppenderStore loggerAppenderStore = new LoggerAppenderStore();
        SLF4JPrintStreamDelegate delegate = new SLF4JPrintStreamDelegate(originalPrintStream, loggerAppenderStore);
        return new SLF4JPrintStreamImpl(originalPrintStream, delegate);
    }

    @Override
    public void restoreOriginalSystemOutputs() {
        for (SystemOutput systemOutput : SystemOutput.values()) {
            PrintStreamCoordinatorImpl.restoreSystemOutput(systemOutput);
        }
    }

    private static void restoreSystemOutput(SystemOutput systemOutput) {
        SLF4JPrintStream slf4jPrintStream = (SLF4JPrintStream)((Object)systemOutput.get());
        systemOutput.set(slf4jPrintStream.getOriginalPrintStream());
    }
}

