/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ws.security.policy.WSS4JPolicyData;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.AlgorithmSuite;
import org.apache.ws.security.policy.model.AsymmetricBinding;
import org.apache.ws.security.policy.model.Binding;
import org.apache.ws.security.policy.model.EncryptionToken;
import org.apache.ws.security.policy.model.Header;
import org.apache.ws.security.policy.model.InitiatorToken;
import org.apache.ws.security.policy.model.PolicyEngineData;
import org.apache.ws.security.policy.model.RecipientToken;
import org.apache.ws.security.policy.model.SignatureToken;
import org.apache.ws.security.policy.model.SignedEncryptedElements;
import org.apache.ws.security.policy.model.SignedEncryptedParts;
import org.apache.ws.security.policy.model.SupportingToken;
import org.apache.ws.security.policy.model.SymmetricAsymmetricBindingBase;
import org.apache.ws.security.policy.model.SymmetricBinding;
import org.apache.ws.security.policy.model.Wss10;
import org.apache.ws.security.policy.model.Wss11;

public class WSS4JPolicyBuilder {
    public static WSS4JPolicyData build(ArrayList topLevelPeds) throws WSSPolicyException {
        Iterator topLevelPEDIterator = topLevelPeds.iterator();
        WSS4JPolicyData wpd = new WSS4JPolicyData();
        while (topLevelPEDIterator.hasNext()) {
            PolicyEngineData ped = (PolicyEngineData)topLevelPEDIterator.next();
            if (ped instanceof Binding) {
                if (ped instanceof SymmetricBinding) {
                    WSS4JPolicyBuilder.processSymmetricPolicyBinding((SymmetricBinding)ped, wpd);
                    continue;
                }
                WSS4JPolicyBuilder.processAsymmetricPolicyBinding((AsymmetricBinding)ped, wpd);
                continue;
            }
            if (ped instanceof Wss11) {
                WSS4JPolicyBuilder.processWSS11((Wss11)ped, wpd);
                continue;
            }
            if (ped instanceof Wss10) {
                WSS4JPolicyBuilder.processWSS10((Wss10)ped, wpd);
                continue;
            }
            if (ped instanceof SignedEncryptedElements) {
                WSS4JPolicyBuilder.processSignedEncryptedElements((SignedEncryptedElements)ped, wpd);
                continue;
            }
            if (ped instanceof SignedEncryptedParts) {
                WSS4JPolicyBuilder.processSignedEncryptedParts((SignedEncryptedParts)ped, wpd);
                continue;
            }
            if (ped instanceof SupportingToken) {
                WSS4JPolicyBuilder.processSupportingToken((SupportingToken)ped, wpd);
                continue;
            }
            System.out.println("Unknown top level PED found: " + ped.getClass().getName());
        }
        return wpd;
    }

    private static void processSymmetricPolicyBinding(SymmetricBinding symmBinding, WSS4JPolicyData wpd) throws WSSPolicyException {
        wpd.setSymmetricBinding(true);
        WSS4JPolicyBuilder.binding(symmBinding, wpd);
        WSS4JPolicyBuilder.symmAsymmBinding(symmBinding, wpd);
        WSS4JPolicyBuilder.symmetricBinding(symmBinding, wpd);
    }

    private static void processWSS10(Wss10 wss10, WSS4JPolicyData wpd) {
        System.out.println("Top level PED found: " + wss10.getClass().getName());
    }

    private static void processAsymmetricPolicyBinding(AsymmetricBinding binding, WSS4JPolicyData wpd) throws WSSPolicyException {
        wpd.setSymmetricBinding(false);
        WSS4JPolicyBuilder.binding(binding, wpd);
        WSS4JPolicyBuilder.symmAsymmBinding(binding, wpd);
        WSS4JPolicyBuilder.asymmetricBinding(binding, wpd);
    }

    private static void processWSS11(Wss11 wss11, WSS4JPolicyData wpd) {
        wpd.setSignatureConfirmation(wss11.isRequireSignatureConfirmation());
    }

    private static void processSignedEncryptedElements(SignedEncryptedElements see, WSS4JPolicyData wpd) {
        Iterator it = see.getXPathExpressions().iterator();
        if (see.isSignedElements()) {
            while (it.hasNext()) {
                wpd.setSignedElements((String)it.next());
            }
        } else {
            while (it.hasNext()) {
                wpd.setEncryptedElements((String)it.next());
            }
        }
    }

    private static void processSignedEncryptedParts(SignedEncryptedParts sep, WSS4JPolicyData wpd) {
        Iterator it = sep.getHeaders().iterator();
        if (sep.isSignedParts()) {
            wpd.setSignBody(sep.isBody());
            while (it.hasNext()) {
                Header header = (Header)it.next();
                wpd.setSignedParts(header.getNamespace(), header.getName());
            }
        } else {
            wpd.setEncryptBody(sep.isBody());
            while (it.hasNext()) {
                Header header = (Header)it.next();
                wpd.setEncryptedParts(header.getNamespace(), header.getName());
            }
        }
    }

    private static void binding(Binding binding, WSS4JPolicyData wpd) {
        wpd.setLayout(binding.getLayout().getValue());
        wpd.setIncludeTimestamp(binding.isIncludeTimestamp());
    }

    private static void symmAsymmBinding(SymmetricAsymmetricBindingBase binding, WSS4JPolicyData wpd) {
        wpd.setEntireHeaderAndBodySignatures(binding.isEntireHeaderAndBodySignatures());
        wpd.setProtectionOrder(binding.getProtectionOrder());
        wpd.setSignatureProtection(binding.isSignatureProtection());
        wpd.setTokenProtection(binding.isTokenProtection());
    }

    private static void symmetricBinding(SymmetricBinding binding, WSS4JPolicyData wpd) throws WSSPolicyException {
        PolicyEngineData ped = binding.getProtectionToken();
        AlgorithmSuite suite = binding.getAlgorithmSuite();
        if (ped != null) {
            wpd.setProtectionToken(ped.getProtectionToken(), suite);
        } else {
            ped = binding.getEncryptionToken();
            SignatureToken ped1 = binding.getSignatureToken();
            if (ped != null || ped1 == null) {
                // empty if block
            }
            wpd.setEncryptionToken(((EncryptionToken)ped).getEncryptionToken(), suite);
            wpd.setSignatureToken(((SignatureToken)ped).getSignatureToken(), suite);
        }
    }

    private static void asymmetricBinding(AsymmetricBinding binding, WSS4JPolicyData wpd) throws WSSPolicyException {
        RecipientToken ped = binding.getRecipientToken();
        InitiatorToken ped1 = binding.getInitiatorToken();
        if (ped != null || ped1 == null) {
            // empty if block
        }
        AlgorithmSuite suite = binding.getAlgorithmSuite();
        wpd.setRecipientToken(ped.getRecipientToken(), suite);
        wpd.setInitiatorToken(ped1.getInitiatorToken(), suite);
    }

    private static void processSupportingToken(SupportingToken token, WSS4JPolicyData wpd) throws WSSPolicyException {
        wpd.setSupportingToken(token);
    }
}

