/*
 * Decompiled with CFR 0.152.
 */
package xdoclet;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import xdoclet.SubTask;

public class DocletContext {
    private static DocletContext singleInstance = null;
    private String destDir;
    private String mergeDir;
    private String excludedTags;
    private SubTask[] subTasks;
    private Hashtable properties;
    private HashMap configs;
    private boolean force;
    private boolean verbose;
    private String addedTags;
    private Map unmodifiableProperties;
    private SubTask activeSubTask;

    public DocletContext(String destDir, String mergeDir, String excludedTags, SubTask[] subTasks, Hashtable properties, HashMap configs, boolean force, boolean verbose, String addedTags) {
        this.destDir = destDir;
        this.mergeDir = mergeDir;
        this.excludedTags = excludedTags;
        this.subTasks = subTasks;
        this.properties = properties;
        this.configs = configs;
        this.force = force;
        this.verbose = verbose;
        this.addedTags = addedTags;
    }

    public static DocletContext getInstance() {
        return singleInstance;
    }

    public static void setSingleInstance(DocletContext singleInstance) {
        DocletContext.singleInstance = singleInstance;
    }

    public SubTask getActiveSubTask() {
        return this.activeSubTask;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public String getMergeDir() {
        return this.mergeDir;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getAddedTags() {
        return this.addedTags;
    }

    public String getExcludedTags() {
        if (this.excludedTags == null) {
            return "";
        }
        return this.excludedTags;
    }

    public SubTask[] getSubTasks() {
        return this.subTasks;
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public Map getProperties() {
        if (this.unmodifiableProperties == null) {
            this.unmodifiableProperties = Collections.unmodifiableMap(this.properties);
        }
        return this.unmodifiableProperties;
    }

    public Object getConfigParam(String name) {
        return this.configs.get(name.toLowerCase());
    }

    public boolean isSubTaskDefined(String subtaskName) {
        return this.getSubTaskBy(subtaskName) != null;
    }

    public SubTask getSubTaskBy(String subtaskName) {
        for (int i = 0; i < this.subTasks.length; ++i) {
            if (this.subTasks[i] == null || !this.subTasks[i].getSubTaskName().toLowerCase().equals(subtaskName.toLowerCase())) continue;
            return this.subTasks[i];
        }
        return null;
    }

    public void setActiveSubTask(SubTask activeSubTask) {
        this.activeSubTask = activeSubTask;
    }
}

