/*
 * $Id: AttributeDecl.java,v 1.2 1999/04/11 17:22:50 db Exp $
 * 
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */


package com.sun.xml.parser;


/**
 * Encapsulate an attribute declaration.
 *
 * @author David Brownell
 * @version $Revision: 1.2 $
 */
class AttributeDecl
{
    String	name;
    
    String	type;
    String	values [];	// for notation, enumeration only
    
    String	defaultValue;
    boolean	isRequired;
    boolean	isFixed;
    boolean	isFromInternalSubset;
    
    final static String	CDATA = "CDATA";
    
    final static String	ID = "ID";
    final static String	IDREF = "IDREF";
    final static String	IDREFS = "IDREFS";
    final static String	ENTITY = "ENTITY";
    final static String	ENTITIES = "ENTITIES";
    final static String	NMTOKEN = "NMTOKEN";
    final static String	NMTOKENS = "NMTOKENS";
    
    final static String	NOTATION = "NOTATION";
    
    final static String	ENUMERATION = "ENUMERATION";
    
    AttributeDecl (String s) { name = s; }
}

