/*
 * $Id: ParseContext.java,v 1.2 1999/04/04 18:49:07 db Exp $
 * 
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package com.sun.xml.tree;

import java.util.Locale;

import org.xml.sax.*;

/**
 * This interface is used during parsing of XML content to encapsulate
 * information about the location of the parsing event being reported.
 * It is used to report diagnostics for application level problems that
 * relate to the data which was successfuly parsed, and to resolve
 * relative URIs.
 *
 * @author David Brownell
 * @version $Revision: 1.2 $
 */
public interface ParseContext
{
    /**
     * Returns an error handler that may be used to report problems
     * of various types:  warnings, recoverable errors, fatal errors.
     */
    ErrorHandler getErrorHandler ();

    /**
     * Returns the preferred locale for diagnostic messsages to be
     * reported through the error handler.  If this locale is not
     * supported by the appropriate message catalog, it is suggested
     * that messages include some sort of diagnostic identifier which
     * is the same in all locales.
     */
    Locale getLocale ();

    /**
     * Returns a locator object which reports where the parse event
     * was detected.  The <em>systemId</em> is the base URI to be used
     * when resolving relative URIs, and other information is used
     * in diagnostics.
     */
    Locator getLocator ();
}
