// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P>The <A HREF='Text.html'><CODE>Text</CODE></A> interface represents the textual
      content (termed <loc href="http://www.w3.org/TR/REC-xml#syntax">character 
      data</loc> in XML) of an <A HREF='Element.html'><CODE>Element</CODE></A> or <A HREF='Attr.html'><CODE>Attr</CODE></A>. 
      If there is no markup inside an element's content, the text is contained
      in a single object implementing the <A HREF='Text.html'><CODE>Text</CODE></A> interface that
      is the only child of the element. If there is markup, it is parsed into
      a list of elements and <A HREF='Text.html'><CODE>Text</CODE></A> nodes that form the list of
      children of the element.
<P>When a document is first made available via the DOM, there is 
      only one <A HREF='Text.html'><CODE>Text</CODE></A> node for each block of text. Users may create 
      adjacent <A HREF='Text.html'><CODE>Text</CODE></A> nodes that represent the 
      contents of a given element without any intervening markup, but
      should be aware that there is no way to represent the separations
      between these nodes in XML or HTML, so they will not (in general)
      persist between DOM editing sessions. The <code>normalize()</code>
      method on <A HREF='Element.html'><CODE>Element</CODE></A> merges any such adjacent <A HREF='Text.html'><CODE>Text</CODE></A>
      objects into a single node for each block of text; this is 
      recommended before employing operations that depend on a particular
      document structure, such as navigation with <code>XPointers.</code>

*/
public interface Text
extends CharacterData
{
/**
<P>Breaks this <A HREF='Text.html'><CODE>Text</CODE></A> node into two Text nodes at the
	specified offset, keeping both in the tree as siblings. This node then
	only contains all the content up to the <code>offset</code> point. And
	a new <A HREF='Text.html'><CODE>Text</CODE></A> node, which is inserted as the next sibling of 
	this node, contains all the content at and after the
	<code>offset</code> point.

@return The new <A HREF='Text.html'><CODE>Text</CODE></A> node.
@param offset
The offset at which to split, starting from 0.
@exception INDEX_SIZE_ERR: Raised if the specified offset is negative or
	greater than the number of characters in <code>data</code>.<P>NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

*/
Text splitText (int offset) throws DOMException;

}
