// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>All HTML element interfaces derive from this class. Elements that only expose the HTML core attributes are represented by the base 
    <A HREF='HTMLElement.html'><CODE>HTMLElement</CODE></A> interface. These elements are as follows:
  
</P>
  <UL>

    <LI>
      <P>HEAD
</P>
    </LI>

    <LI>
      <P>special: SUB, SUP, SPAN, BDO
</P>
    </LI>

    <LI>
      <P>font: TT, I, B, U, S, STRIKE, BIG, SMALL
</P>
    </LI>

    <LI>
      <P>phrase: EM, STRONG, DFN, CODE, SAMP, KBD, VAR, CITE, ACRONYM, ABBR
</P>
    </LI>

    <LI>
      <P>list: DD, DT
</P>
    </LI>

    <LI>
      <P>NOFRAMES, NOSCRIPT
</P>
    </LI>

    <LI>
      <P>ADDRESS, CENTER
</P>
    </LI>

  </UL>

  <P>
    <emph>Note.</emph> The 
    <code>style</code> attribute for this interface is reserved for future usage. 
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-id><CODE>&nbsp;id</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getId()'>getId</a>
<a href='#setId(java.lang.String)'>setId</a>
</TD>
<TD>
  <P>The element's identifier. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-id">id attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-title><CODE>&nbsp;title</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTitle()'>getTitle</a>
<a href='#setTitle(java.lang.String)'>setTitle</a>
</TD>
<TD>
  <P>The element's advisory title. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-title">title attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-lang><CODE>&nbsp;lang</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getLang()'>getLang</a>
<a href='#setLang(java.lang.String)'>setLang</a>
</TD>
<TD>
  <P>Language code defined in RFC 1766. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/dirlang.html#adef-lang">lang attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-dir><CODE>&nbsp;dir</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDir()'>getDir</a>
<a href='#setDir(java.lang.String)'>setDir</a>
</TD>
<TD>
  <P>Specifies the base direction of directionally neutral text and the directionality of tables. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/dirlang.html#adef-dir">dir attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-className><CODE>&nbsp;className</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getClassName()'>getClassName</a>
<a href='#setClassName(java.lang.String)'>setClassName</a>
</TD>
<TD>
  <P>The class attribute of the element. This attribute has been renamed due to conflicts with the "class" keyword exposed by many languages. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-class">class attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLElement
extends Element
{
	/** Assigns the value of the <code><a href=#att-id>id</a></code> property.
	 */
	void setId (String id);

	/**
	 * Returns the value of the <code><a href=#att-id>id</a></code> property.
	*/
	String getId ();


	/** Assigns the value of the <code><a href=#att-title>title</a></code> property.
	 */
	void setTitle (String title);

	/**
	 * Returns the value of the <code><a href=#att-title>title</a></code> property.
	*/
	String getTitle ();


	/** Assigns the value of the <code><a href=#att-lang>lang</a></code> property.
	 */
	void setLang (String lang);

	/**
	 * Returns the value of the <code><a href=#att-lang>lang</a></code> property.
	*/
	String getLang ();


	/** Assigns the value of the <code><a href=#att-dir>dir</a></code> property.
	 */
	void setDir (String dir);

	/**
	 * Returns the value of the <code><a href=#att-dir>dir</a></code> property.
	*/
	String getDir ();


	/** Assigns the value of the <code><a href=#att-className>className</a></code> property.
	 */
	void setClassName (String className);

	/**
	 * Returns the value of the <code><a href=#att-className>className</a></code> property.
	*/
	String getClassName ();


}
