// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>Embedded image. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#edef-IMG">IMG element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-lowSrc><CODE>&nbsp;lowSrc</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getLowSrc()'>getLowSrc</a>
<a href='#setLowSrc(java.lang.String)'>setLowSrc</a>
</TD>
<TD>
  <P>URI designating the source of this image, for low-resolution output. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-name><CODE>&nbsp;name</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getName()'>getName</a>
<a href='#setName(java.lang.String)'>setName</a>
</TD>
<TD>
  <P>The name of the element (for backwards compatibility). 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-align><CODE>&nbsp;align</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAlign()'>getAlign</a>
<a href='#setAlign(java.lang.String)'>setAlign</a>
</TD>
<TD>
  <P>Aligns this object (vertically or horizontally) with respect to its surrounding text. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-align-IMG">align attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-alt><CODE>&nbsp;alt</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAlt()'>getAlt</a>
<a href='#setAlt(java.lang.String)'>setAlt</a>
</TD>
<TD>
  <P>Alternate text for user agents not rendering the normal content of this element. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-alt">alt attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-border><CODE>&nbsp;border</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getBorder()'>getBorder</a>
<a href='#setBorder(java.lang.String)'>setBorder</a>
</TD>
<TD>
  <P>Width of border around image. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-border-IMG">border attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-height><CODE>&nbsp;height</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getHeight()'>getHeight</a>
<a href='#setHeight(java.lang.String)'>setHeight</a>
</TD>
<TD>
  <P>Override height. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-height-IMG">height attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-hspace><CODE>&nbsp;hspace</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getHspace()'>getHspace</a>
<a href='#setHspace(java.lang.String)'>setHspace</a>
</TD>
<TD>
  <P>Horizontal space to the left and right of this image. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-hspace">hspace attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-isMap><CODE>&nbsp;isMap</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getIsMap()'>getIsMap</a>
<a href='#setIsMap(java.lang.String)'>setIsMap</a>
</TD>
<TD>
  <P>Use server-side image map. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-ismap">ismap attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-longDesc><CODE>&nbsp;longDesc</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getLongDesc()'>getLongDesc</a>
<a href='#setLongDesc(java.lang.String)'>setLongDesc</a>
</TD>
<TD>
  <P>URI designating a long description of this image or frame. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-longdesc-IMG">longdesc attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-src><CODE>&nbsp;src</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSrc()'>getSrc</a>
<a href='#setSrc(java.lang.String)'>setSrc</a>
</TD>
<TD>
  <P>URI designating the source of this image. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-src-IMG">src attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-useMap><CODE>&nbsp;useMap</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getUseMap()'>getUseMap</a>
<a href='#setUseMap(java.lang.String)'>setUseMap</a>
</TD>
<TD>
  <P>Use client-side image map. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-usemap">usemap attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-vspace><CODE>&nbsp;vspace</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getVspace()'>getVspace</a>
<a href='#setVspace(java.lang.String)'>setVspace</a>
</TD>
<TD>
  <P>Vertical space above and below this image. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-vspace">vspace attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-width><CODE>&nbsp;width</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getWidth()'>getWidth</a>
<a href='#setWidth(java.lang.String)'>setWidth</a>
</TD>
<TD>
  <P>Override width. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-width-IMG">width attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLImageElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-lowSrc>lowSrc</a></code> property.
	 */
	void setLowSrc (String lowSrc);

	/**
	 * Returns the value of the <code><a href=#att-lowSrc>lowSrc</a></code> property.
	*/
	String getLowSrc ();


	/** Assigns the value of the <code><a href=#att-name>name</a></code> property.
	 */
	void setName (String name);

	/**
	 * Returns the value of the <code><a href=#att-name>name</a></code> property.
	*/
	String getName ();


	/** Assigns the value of the <code><a href=#att-align>align</a></code> property.
	 */
	void setAlign (String align);

	/**
	 * Returns the value of the <code><a href=#att-align>align</a></code> property.
	*/
	String getAlign ();


	/** Assigns the value of the <code><a href=#att-alt>alt</a></code> property.
	 */
	void setAlt (String alt);

	/**
	 * Returns the value of the <code><a href=#att-alt>alt</a></code> property.
	*/
	String getAlt ();


	/** Assigns the value of the <code><a href=#att-border>border</a></code> property.
	 */
	void setBorder (String border);

	/**
	 * Returns the value of the <code><a href=#att-border>border</a></code> property.
	*/
	String getBorder ();


	/** Assigns the value of the <code><a href=#att-height>height</a></code> property.
	 */
	void setHeight (String height);

	/**
	 * Returns the value of the <code><a href=#att-height>height</a></code> property.
	*/
	String getHeight ();


	/** Assigns the value of the <code><a href=#att-hspace>hspace</a></code> property.
	 */
	void setHspace (String hspace);

	/**
	 * Returns the value of the <code><a href=#att-hspace>hspace</a></code> property.
	*/
	String getHspace ();


	/** Assigns the value of the <code><a href=#att-isMap>isMap</a></code> property.
	 */
	void setIsMap (boolean isMap);

	/**
	 * Returns the value of the <code><a href=#att-isMap>isMap</a></code> property.
	*/
	boolean getIsMap ();


	/** Assigns the value of the <code><a href=#att-longDesc>longDesc</a></code> property.
	 */
	void setLongDesc (String longDesc);

	/**
	 * Returns the value of the <code><a href=#att-longDesc>longDesc</a></code> property.
	*/
	String getLongDesc ();


	/** Assigns the value of the <code><a href=#att-src>src</a></code> property.
	 */
	void setSrc (String src);

	/**
	 * Returns the value of the <code><a href=#att-src>src</a></code> property.
	*/
	String getSrc ();


	/** Assigns the value of the <code><a href=#att-useMap>useMap</a></code> property.
	 */
	void setUseMap (String useMap);

	/**
	 * Returns the value of the <code><a href=#att-useMap>useMap</a></code> property.
	*/
	String getUseMap ();


	/** Assigns the value of the <code><a href=#att-vspace>vspace</a></code> property.
	 */
	void setVspace (String vspace);

	/**
	 * Returns the value of the <code><a href=#att-vspace>vspace</a></code> property.
	*/
	String getVspace ();


	/** Assigns the value of the <code><a href=#att-width>width</a></code> property.
	 */
	void setWidth (String width);

	/**
	 * Returns the value of the <code><a href=#att-width>width</a></code> property.
	*/
	String getWidth ();


}
