// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>Generic embedded object. 
    <emph>Note.</emph> In principle, all properties on the object element are read-write but in some environments some properties may be read-only once the underlying object is instantiated. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#edef-OBJECT">OBJECT element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-form><CODE>&nbsp;form</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getForm()'>getForm</a>
</TD>
<TD>
  <P>Returns the 
    <code>FORM</code> element containing this control. Returns null if this control is not within the context of a form. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-code><CODE>&nbsp;code</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCode()'>getCode</a>
<a href='#setCode(java.lang.String)'>setCode</a>
</TD>
<TD>
  <P>Applet class file. See the 
    <code>code</code> attribute for HTMLAppletElement. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-align><CODE>&nbsp;align</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAlign()'>getAlign</a>
<a href='#setAlign(java.lang.String)'>setAlign</a>
</TD>
<TD>
  <P>Aligns this object (vertically or horizontally) with respect to its surrounding text. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-align-IMG">align attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-archive><CODE>&nbsp;archive</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getArchive()'>getArchive</a>
<a href='#setArchive(java.lang.String)'>setArchive</a>
</TD>
<TD>
  <P>Space-separated list of archives. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-archive-OBJECT">archive attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-border><CODE>&nbsp;border</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getBorder()'>getBorder</a>
<a href='#setBorder(java.lang.String)'>setBorder</a>
</TD>
<TD>
  <P>Width of border around the object. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-border">border attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-codeBase><CODE>&nbsp;codeBase</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCodeBase()'>getCodeBase</a>
<a href='#setCodeBase(java.lang.String)'>setCodeBase</a>
</TD>
<TD>
  <P>Base URI for 
    <code>classid</code>, 
    <code>data</code>, and 
    <code>archive</code> attributes. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-codebase-OBJECT">codebase attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-codeType><CODE>&nbsp;codeType</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCodeType()'>getCodeType</a>
<a href='#setCodeType(java.lang.String)'>setCodeType</a>
</TD>
<TD>
  <P>Content type for data downloaded via 
    <code>classid</code> attribute. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-codetype">codetype attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-data><CODE>&nbsp;data</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getData()'>getData</a>
<a href='#setData(java.lang.String)'>setData</a>
</TD>
<TD>
  <P>A URI specifying the location of the object's data. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-data">data attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-declare><CODE>&nbsp;declare</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDeclare()'>getDeclare</a>
<a href='#setDeclare(java.lang.String)'>setDeclare</a>
</TD>
<TD>
  <P>Declare (for future reference), but do not instantiate, this object. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-declare">declare attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-height><CODE>&nbsp;height</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getHeight()'>getHeight</a>
<a href='#setHeight(java.lang.String)'>setHeight</a>
</TD>
<TD>
  <P>Override height. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-height-IMG">height attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-hspace><CODE>&nbsp;hspace</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getHspace()'>getHspace</a>
<a href='#setHspace(java.lang.String)'>setHspace</a>
</TD>
<TD>
  <P>Horizontal space to the left and right of this image, applet, or object. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-hspace">hspace attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-name><CODE>&nbsp;name</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getName()'>getName</a>
<a href='#setName(java.lang.String)'>setName</a>
</TD>
<TD>
  <P>Form control or object name when submitted with a form. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-name-INPUT">name attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-standby><CODE>&nbsp;standby</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getStandby()'>getStandby</a>
<a href='#setStandby(java.lang.String)'>setStandby</a>
</TD>
<TD>
  <P>Message to render while loading the object. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-standby">standby attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-tabIndex><CODE>&nbsp;tabIndex</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTabIndex()'>getTabIndex</a>
<a href='#setTabIndex(java.lang.String)'>setTabIndex</a>
</TD>
<TD>
  <P>Index that represents the element's position in the tabbing order. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-tabindex">tabindex attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-type><CODE>&nbsp;type</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getType()'>getType</a>
<a href='#setType(java.lang.String)'>setType</a>
</TD>
<TD>
  <P>Content type for data downloaded via 
    <code>data</code> attribute. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-type-OBJECT">type attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-useMap><CODE>&nbsp;useMap</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getUseMap()'>getUseMap</a>
<a href='#setUseMap(java.lang.String)'>setUseMap</a>
</TD>
<TD>
  <P>Use client-side image map. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-usemap">usemap attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-vspace><CODE>&nbsp;vspace</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getVspace()'>getVspace</a>
<a href='#setVspace(java.lang.String)'>setVspace</a>
</TD>
<TD>
  <P>Vertical space above and below this image, applet, or object. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-vspace">vspace attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-width><CODE>&nbsp;width</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getWidth()'>getWidth</a>
<a href='#setWidth(java.lang.String)'>setWidth</a>
</TD>
<TD>
  <P>Override width. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-width-IMG">width attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLObjectElement
extends HTMLElement
{
	/**
	 * Returns the value of the <code><a href=#att-form>form</a></code> property.
	*/
	HTMLFormElement getForm ();


	/** Assigns the value of the <code><a href=#att-code>code</a></code> property.
	 */
	void setCode (String code);

	/**
	 * Returns the value of the <code><a href=#att-code>code</a></code> property.
	*/
	String getCode ();


	/** Assigns the value of the <code><a href=#att-align>align</a></code> property.
	 */
	void setAlign (String align);

	/**
	 * Returns the value of the <code><a href=#att-align>align</a></code> property.
	*/
	String getAlign ();


	/** Assigns the value of the <code><a href=#att-archive>archive</a></code> property.
	 */
	void setArchive (String archive);

	/**
	 * Returns the value of the <code><a href=#att-archive>archive</a></code> property.
	*/
	String getArchive ();


	/** Assigns the value of the <code><a href=#att-border>border</a></code> property.
	 */
	void setBorder (String border);

	/**
	 * Returns the value of the <code><a href=#att-border>border</a></code> property.
	*/
	String getBorder ();


	/** Assigns the value of the <code><a href=#att-codeBase>codeBase</a></code> property.
	 */
	void setCodeBase (String codeBase);

	/**
	 * Returns the value of the <code><a href=#att-codeBase>codeBase</a></code> property.
	*/
	String getCodeBase ();


	/** Assigns the value of the <code><a href=#att-codeType>codeType</a></code> property.
	 */
	void setCodeType (String codeType);

	/**
	 * Returns the value of the <code><a href=#att-codeType>codeType</a></code> property.
	*/
	String getCodeType ();


	/** Assigns the value of the <code><a href=#att-data>data</a></code> property.
	 */
	void setData (String data);

	/**
	 * Returns the value of the <code><a href=#att-data>data</a></code> property.
	*/
	String getData ();


	/** Assigns the value of the <code><a href=#att-declare>declare</a></code> property.
	 */
	void setDeclare (boolean declare);

	/**
	 * Returns the value of the <code><a href=#att-declare>declare</a></code> property.
	*/
	boolean getDeclare ();


	/** Assigns the value of the <code><a href=#att-height>height</a></code> property.
	 */
	void setHeight (String height);

	/**
	 * Returns the value of the <code><a href=#att-height>height</a></code> property.
	*/
	String getHeight ();


	/** Assigns the value of the <code><a href=#att-hspace>hspace</a></code> property.
	 */
	void setHspace (String hspace);

	/**
	 * Returns the value of the <code><a href=#att-hspace>hspace</a></code> property.
	*/
	String getHspace ();


	/** Assigns the value of the <code><a href=#att-name>name</a></code> property.
	 */
	void setName (String name);

	/**
	 * Returns the value of the <code><a href=#att-name>name</a></code> property.
	*/
	String getName ();


	/** Assigns the value of the <code><a href=#att-standby>standby</a></code> property.
	 */
	void setStandby (String standby);

	/**
	 * Returns the value of the <code><a href=#att-standby>standby</a></code> property.
	*/
	String getStandby ();


	/** Assigns the value of the <code><a href=#att-tabIndex>tabIndex</a></code> property.
	 */
	void setTabIndex (int tabIndex);

	/**
	 * Returns the value of the <code><a href=#att-tabIndex>tabIndex</a></code> property.
	*/
	int getTabIndex ();


	/** Assigns the value of the <code><a href=#att-type>type</a></code> property.
	 */
	void setType (String type);

	/**
	 * Returns the value of the <code><a href=#att-type>type</a></code> property.
	*/
	String getType ();


	/** Assigns the value of the <code><a href=#att-useMap>useMap</a></code> property.
	 */
	void setUseMap (String useMap);

	/**
	 * Returns the value of the <code><a href=#att-useMap>useMap</a></code> property.
	*/
	String getUseMap ();


	/** Assigns the value of the <code><a href=#att-vspace>vspace</a></code> property.
	 */
	void setVspace (String vspace);

	/**
	 * Returns the value of the <code><a href=#att-vspace>vspace</a></code> property.
	*/
	String getVspace ();


	/** Assigns the value of the <code><a href=#att-width>width</a></code> property.
	 */
	void setWidth (String width);

	/**
	 * Returns the value of the <code><a href=#att-width>width</a></code> property.
	*/
	String getWidth ();


}
