// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>Style information. A more detailed style sheet object model is planned to be defined in a separate document. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/styles.html#edef-STYLE">STYLE element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-disabled><CODE>&nbsp;disabled</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDisabled()'>getDisabled</a>
<a href='#setDisabled(java.lang.String)'>setDisabled</a>
</TD>
<TD>
  <P>Enables/disables the style sheet. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-media><CODE>&nbsp;media</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getMedia()'>getMedia</a>
<a href='#setMedia(java.lang.String)'>setMedia</a>
</TD>
<TD>
  <P>Designed for use with one or more target media. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/styles.html#adef-media">media attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-type><CODE>&nbsp;type</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getType()'>getType</a>
<a href='#setType(java.lang.String)'>setType</a>
</TD>
<TD>
  <P>The style sheet language (Internet media type). See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/styles.html#adef-type-STYLE">type attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLStyleElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-disabled>disabled</a></code> property.
	 */
	void setDisabled (boolean disabled);

	/**
	 * Returns the value of the <code><a href=#att-disabled>disabled</a></code> property.
	*/
	boolean getDisabled ();


	/** Assigns the value of the <code><a href=#att-media>media</a></code> property.
	 */
	void setMedia (String media);

	/**
	 * Returns the value of the <code><a href=#att-media>media</a></code> property.
	*/
	String getMedia ();


	/** Assigns the value of the <code><a href=#att-type>type</a></code> property.
	 */
	void setType (String type);

	/**
	 * Returns the value of the <code><a href=#att-type>type</a></code> property.
	*/
	String getType ();


}
