// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>Regroups the 
    <code>COL</code> and 
    <code>COLGROUP</code> elements. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#edef-COL">COL element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-align><CODE>&nbsp;align</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAlign()'>getAlign</a>
<a href='#setAlign(java.lang.String)'>setAlign</a>
</TD>
<TD>
  <P>Horizontal alignment of cell data in column. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-align-TD">align attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-ch><CODE>&nbsp;ch</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCh()'>getCh</a>
<a href='#setCh(java.lang.String)'>setCh</a>
</TD>
<TD>
  <P>Alignment character for cells in a column. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-char">char attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-chOff><CODE>&nbsp;chOff</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getChOff()'>getChOff</a>
<a href='#setChOff(java.lang.String)'>setChOff</a>
</TD>
<TD>
  <P>Offset of alignment character. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-charoff">charoff attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-span><CODE>&nbsp;span</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSpan()'>getSpan</a>
<a href='#setSpan(java.lang.String)'>setSpan</a>
</TD>
<TD>
  <P>Indicates the number of columns in a group or affected by a grouping. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-span-COL">span attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-vAlign><CODE>&nbsp;vAlign</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getVAlign()'>getVAlign</a>
<a href='#setVAlign(java.lang.String)'>setVAlign</a>
</TD>
<TD>
  <P>Vertical alignment of cell data in column. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-valign">valign attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-width><CODE>&nbsp;width</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getWidth()'>getWidth</a>
<a href='#setWidth(java.lang.String)'>setWidth</a>
</TD>
<TD>
  <P>Default column width. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-width-COL">width attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLTableColElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-align>align</a></code> property.
	 */
	void setAlign (String align);

	/**
	 * Returns the value of the <code><a href=#att-align>align</a></code> property.
	*/
	String getAlign ();


	/** Assigns the value of the <code><a href=#att-ch>ch</a></code> property.
	 */
	void setCh (String ch);

	/**
	 * Returns the value of the <code><a href=#att-ch>ch</a></code> property.
	*/
	String getCh ();


	/** Assigns the value of the <code><a href=#att-chOff>chOff</a></code> property.
	 */
	void setChOff (String chOff);

	/**
	 * Returns the value of the <code><a href=#att-chOff>chOff</a></code> property.
	*/
	String getChOff ();


	/** Assigns the value of the <code><a href=#att-span>span</a></code> property.
	 */
	void setSpan (int span);

	/**
	 * Returns the value of the <code><a href=#att-span>span</a></code> property.
	*/
	int getSpan ();


	/** Assigns the value of the <code><a href=#att-vAlign>vAlign</a></code> property.
	 */
	void setVAlign (String vAlign);

	/**
	 * Returns the value of the <code><a href=#att-vAlign>vAlign</a></code> property.
	*/
	String getVAlign ();


	/** Assigns the value of the <code><a href=#att-width>width</a></code> property.
	 */
	void setWidth (String width);

	/**
	 * Returns the value of the <code><a href=#att-width>width</a></code> property.
	*/
	String getWidth ();


}
