// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>The 
    <code>THEAD</code>, 
    <code>TFOOT</code>, and 
    <code>TBODY</code>
elements. 
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-align><CODE>&nbsp;align</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAlign()'>getAlign</a>
<a href='#setAlign(java.lang.String)'>setAlign</a>
</TD>
<TD>
  <P>Horizontal alignment of data in cells. See the 
    <code>align</code>
attribute for HTMLTheadElement for details. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-ch><CODE>&nbsp;ch</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCh()'>getCh</a>
<a href='#setCh(java.lang.String)'>setCh</a>
</TD>
<TD>
  <P>Alignment character for cells in a column. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-char">char attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-chOff><CODE>&nbsp;chOff</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getChOff()'>getChOff</a>
<a href='#setChOff(java.lang.String)'>setChOff</a>
</TD>
<TD>
  <P>Offset of alignment character. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-charoff">charoff attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-vAlign><CODE>&nbsp;vAlign</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getVAlign()'>getVAlign</a>
<a href='#setVAlign(java.lang.String)'>setVAlign</a>
</TD>
<TD>
  <P>Vertical alignment of data in cells. See the 
    <code>valign</code>
attribute for HTMLTheadElement for details. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-rows><CODE>&nbsp;rows</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getRows()'>getRows</a>
</TD>
<TD>
  <P>The collection of rows in this table section. 
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLTableSectionElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-align>align</a></code> property.
	 */
	void setAlign (String align);

	/**
	 * Returns the value of the <code><a href=#att-align>align</a></code> property.
	*/
	String getAlign ();


	/** Assigns the value of the <code><a href=#att-ch>ch</a></code> property.
	 */
	void setCh (String ch);

	/**
	 * Returns the value of the <code><a href=#att-ch>ch</a></code> property.
	*/
	String getCh ();


	/** Assigns the value of the <code><a href=#att-chOff>chOff</a></code> property.
	 */
	void setChOff (String chOff);

	/**
	 * Returns the value of the <code><a href=#att-chOff>chOff</a></code> property.
	*/
	String getChOff ();


	/** Assigns the value of the <code><a href=#att-vAlign>vAlign</a></code> property.
	 */
	void setVAlign (String vAlign);

	/**
	 * Returns the value of the <code><a href=#att-vAlign>vAlign</a></code> property.
	*/
	String getVAlign ();


	/**
	 * Returns the value of the <code><a href=#att-rows>rows</a></code> property.
	*/
	HTMLCollection getRows ();


/**

  <P>Insert a row into this section.
</P>

@return The newly created row.
@param index
The row number where to insert a new row.
*/
HTMLElement insertRow (int index);

/**

  <P>Delete a row from this section.
</P>

@param index
The index of the row to be deleted.
*/
void deleteRow (int index);

}
